/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.webservices.resources;

import javax.servlet.ServletContextEvent;
import org.compiere.util.CLogger;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

public class ContextLoaderListener
extends org.springframework.web.context.ContextLoaderListener {
    private static final CLogger log = CLogger.getCLogger(ContextLoaderListener.class);

    public void contextInitialized(ServletContextEvent event) {
        Object bundleContextObj = null;
        if (event.getSource() != null && event.getSource() instanceof ContextHandler.StaticContext) {
            ContextHandler.StaticContext staticContext = (ContextHandler.StaticContext)event.getSource();
            bundleContextObj = staticContext.getAttribute("osgi-bundlecontext");
        }
        ClassLoader webappBundleCl = null;
        if (bundleContextObj != null && bundleContextObj instanceof BundleContext) {
            BundleContext webappBundleContext = (BundleContext)bundleContextObj;
            webappBundleCl = ((BundleWiring)webappBundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
        }
        if (webappBundleCl != null) {
            ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(webappBundleCl);
                super.contextInitialized(event);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCl);
            }
        } else {
            log.warning("can't findout ClassLoader for web service:" + event.getServletContext().getContextPath());
        }
    }
}

